<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		URL::redirect('salesman.php');
	}

	$id = intval($_GET['id']);

	if(isset($_POST['submit']) && $_POST['submit'] == 'salesman') {
		if(isset($_POST['method']) && $_POST['method'] == 'update') {
			$result = Salesman::update($id);
		}
	}

	$data = Salesman::detail($id);
	if(!$data) {
		HTML::script('alert("ไม่พบข้อมูล");');
		URL::redirect('salesman.php');
	}
?>
<!DOCTYPE html>
<html>
<?php include 'head.html'; ?>
<body>
	<?php include 'navbar.php'; ?>
	<div class="container">
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 center">
				<h1>เพิ่มพนักงานขาย</h1>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
				<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6" style="margin: auto; float: none;">
					<div class="panel panel-warning">
						<div class="panel-body">
							<form method="post">
							<input type="hidden" name="submit" value="salesman" />
								<input type="hidden" name="method" value="update" />
								<input type="hidden" name="salesman-id" value="<?=$id;?>" />
								<div class="form-group">
									<label for="">คำนำหน้า *</label>
									<select name="title" class="form-control" id="" required>
										<option value="" disabled selected>-- เลือกคำนำหน้า --</option>
										<option value="นาย" <?=isset($data['title']) && $data['title'] == 'นาย'? 'selected' : '';?> >นาย</option>
										<option value="นาง" <?=isset($data['title']) && $data['title'] == 'นาง'? 'selected' : '';?> >นาง</option>
										<option value="นางสาว" <?=isset($data['title']) && $data['title'] == 'นางสาว'? 'selected' : '';?> >นางสาว</option>
										<option value="บริษัท"  <?=isset($data['title'])  &&  $data['title']  ==  'บริษัท'?  'selected'  :  '';?>  >บริษัท</option>
									</select>
									
								</div>
								<div class="form-group">
									<label for="">ชื่อ *</label>
									<input name="firstname" class="form-control" type="text" placeholder="ชื่อ" value="<?=isset($data['firstname']) ? $data['firstname'] : '';?>" required/>
								</div>
								<div class="form-group">
									<label for="">นามสกุล *</label>
									<input name="lastname" class="form-control" type="text" placeholder="นามสกุล" value="<?=isset($data['lastname']) ? $data['lastname'] : '';?>" required/>
								</div>
								<div class="form-group">
									<label for="">ชื่อเล่น</label>
									<input name="nickname" class="form-control" type="text" placeholder="ชื่อเล่น" value="<?=isset($data['nickname']) ? $data['nickname'] : '';?>"/>
								</div>
								<div class="form-group">
									<label for="">ที่อยู่ *</label>
									<textarea name="address" class="form-control" id="" cols="30" rows="5" placeholder="ที่อยู่" style="resize: none;" required><?=isset($data['address']) ? $data['address'] : '';?></textarea>
								</div>
								<div class="form-group">
									<label for="">โทรศัพท์ *</label>
									<input name="phone" class="form-control" type="text" placeholder="โทรศัพท์" value="<?=isset($data['phone']) ? $data['phone'] : '';?>" required/>
								</div>
								<div class="form-group">
									<label for="">มือถือ</label>
									<input name="mobile" class="form-control" type="text" placeholder="มือถือ" value="<?=isset($data['mobile']) ? $data['mobile'] : '';?>"/>
								</div>
								<div class="form-group">
									<label for="">เลขประจำตัวผู้เสียภาษี</label>
									<input name="fax" class="form-control" type="text" placeholder="เลขประจำตัวผู้เสียภาษี" value="<?=isset($data['fax']) ? $data['fax'] : '';?>"/>
								</div>
								<div class="form-group center">
									<button type="reset" class="btn btn-warning">
										<i class="fa fa-undo"></i>
										ล้าง
									</button>
									<button type="submit" class="btn btn-success">
										<i class="fa fa-plus"></i>
										แก้ไขข้อมูลพนักงานขาย
									</button>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
		if(isset($result)) {
			if(!$result['error']) {
				echo HTML::inputAlert('select[name="title"]', 'success', 'แก้ไขข้อมูลพนักงานขายสำเร็จ');
			}
		}
	?>
</body>
</html>