<?php
if($_SERVER['SCRIPT_NAME']=='/include/slide.php')exit();
class SlideShow
{
	public static function getAllSlides(){
		$slides = DB::q('SELECT
			slide_id,
			slide_name
			
		FROM
			slideshow
		ORDER BY
			slide_id
		');
		if(!$slides)return false;
		return $slides;
	}

	public static function insertSlide(){
		if(!User::isAdmin()){
			return false;
		}
		if(!isset($_POST['insert-slide'])||trim($_POST['insert-slide'])==''){
			return false;
		}
	
		$slideId = self::getNextId();
		
		$sql = 'INSERT INTO slideshow(
			slide_id
		) VALUES (
			{id}
		)';

		$q = DB::exc($sql, ['id'=>$slideId,]);

		if(!$q)return false;

		if( sizeof($_FILES) > 0 && isset($_FILES['slide-file']['tmp_name']) && trim($_FILES['slide-file']['tmp_name']) != '' ){

			
			$slideName = 'slide_show_'.ThaiDate::getTimeStamp();
			$f = self::uploadSlide($slideName);
			if(!$f){
				self::deleteSlide($slideId);
				return false;
			}
			$f = PATH::$FILEDOWNLOAD.$f;
			if(!self::updateSlide($slideId, $f)) {
				self::unlinkSlide($f);
				return false;
			}
			
			
		}
		return true;
	}

	private static function unlinkSlide($fn){
		if(!file_exists($fn))return false;
		if(!unlink($fn))return false;
		return true;
	}

	private static function uploadSlide($newName){
		$f = FileManager::requestFile('slide-file');
		if(!$f){
			return false;
		}
		return FileManager::uploadFile($f, PATH::$FILEDOWNLOAD_REAL, $newName);
	}

	private static function updateSlide($slideId, $f){
		$sql = 'UPDATE slideshow SET slide_name = "{f}" WHERE slide_id = {slide_id}';
		$q = DB::exc($sql, ['slide_id'=>$slideId, 'f'=>$f]);
		if(!$q)return false;
		return true;
	}

	public static function deleteSlide($slideId){
		if(!User::isAdmin()){
			return false;
		}
		$sql = 'DELETE FROM slideshow WHERE slide_id = {slide_id}';
		$q = DB::exc($sql, ['slide_id'=>$slideId]);
		if(!$q)return false;
		return true;
	}

	private static function getNextId(){
		return (intval(DB::q('SELECT MAX(slide_id) AS id FROM slideshow')[0]['id'])+1);
	}

	

}
function captureSlide(){
	if(isset($_POST['insert-slide']) && isset($_FILES['slide-file']['tmp_name']) && trim($_FILES['slide-file']['tmp_name']) != '' ){
		if(!SlideShow::insertSlide()){
			URL::redirect('error.php');
		}
		URL::redirect('backend.php');
	}
}

function captureSlideDelete(){
	if( isset($_GET['slide_id']) && intval($_GET['slide_id']) > 0 ){
		if(!SlideShow::deleteSlide(intval($_GET['slide_id']))){
			URL::redirect('error.php');
		}
		URL::redirect('backend.php');
	}
}