<?php
if($_SERVER['SCRIPT_NAME']=='/include/download.php')exit();
class FD
{
	public static function getAllFiles(){
		$files = DB::q('SELECT
			file_id,
			file_name,
			file_name_real
		FROM
			file_download
		ORDER BY
			file_datetime
		');
		if(!$files)return false;
		return $files;
	}

	public static function insertFileDownload(){
		if(!User::isAdmin()){
			return false;
		}
		if(!isset($_POST['insert-file'])||trim($_POST['insert-file'])==''){
			return false;
		}
	
		$fileId = self::getNextId();
		
		$sql = 'INSERT INTO file_download(
			file_id, file_datetime
		) VALUES (
			{id}, NOW()
		)';

		$q = DB::exc($sql, ['id'=>$fileId,]);

		if(!$q)return false;

		if( sizeof($_FILES) > 0 && isset($_FILES['file-download']['tmp_name']) && trim($_FILES['file-download']['tmp_name']) != '' ){

			
			$fileDownloadName = 'file_download_'.ThaiDate::getTimeStamp();
			$f = self::uploadFileDownload($fileDownloadName);
			if(!$f){
				self::deleteFileDownload($fileId);
				return false;
			}
			$f = PATH::$FILEDOWNLOAD.$f;
			if(!self::updateFileDownload($fileId, $f ,trim($_FILES['file-download']['name']))) {
				self::unlinkFileDownload($f);
				return false;
			}
			
			
		}
		return true;
	}

	private static function unlinkFileDownload($fn){
		if(!file_exists($fn))return false;
		if(!unlink($fn))return false;
		return true;
	}

	private static function uploadFileDownload($newName){
		$f = FileManager::requestFile('file-download');
		if(!$f){
			return false;
		}
		return FileManager::uploadFile($f, PATH::$FILEDOWNLOAD_REAL, $newName);
	}

	private static function updateFileDownload($fileId, $f, $fn){
		$sql = 'UPDATE file_download SET file_name = "{f}", file_name_real = "{fn}" WHERE file_id = {file_id}';
		$q = DB::exc($sql, ['file_id'=>$fileId, 'f'=>$f, 'fn'=>$fn]);
		if(!$q)return false;
		return true;
	}

	public static function deleteFileDownload($fileId){
		if(!User::isAdmin()){
			return false;
		}
		$sql = 'DELETE FROM file_download WHERE file_id = {file_id}';
		$q = DB::exc($sql, ['file_id'=>$fileId]);
		if(!$q)return false;
		return true;
	}

	private static function getNextId(){
		return (intval(DB::q('SELECT MAX(file_id) AS id FROM file_download')[0]['id'])+1);
	}

	

}
function captureFileDownload(){
	if(isset($_POST['insert-file']) && isset($_FILES['file-download']['tmp_name']) && trim($_FILES['file-download']['tmp_name']) != '' ){
		if(!FD::insertFileDownload()){
			URL::redirect('error.php');
		}
		URL::redirect('backend-download-file.php');
	}
}

function captureFileDownloadDelete(){
	if( isset($_GET['file_id']) && intval($_GET['file_id']) > 0 ){
		if(!FD::deleteFileDownload(intval($_GET['file_id']))){
			URL::redirect('error.php');
		}
		URL::redirect('backend-download-file.php');
	}
}