<?php
class Customer {
	const TABLE_NAME = 'customer';

	const FIELDS = [
		'name' => [
			'type' => 'string',
			'required' => true,
		],
		'nickname' => [
			'type' => 'string',
			'required' => false,
		],
		'address' => [
			'type' => 'string',
			'required' => false,
		],
		'tax_value' => [
			'type' => 'number',
			'required' => true,
			'default' => 0,
		],
		'phone' => [
			'type' => 'string',
			'required' => false,
		],
		'mobile' => [
			'type' => 'string',
			'required' => false,
		]
	];

	public static function create() {
		if(!self::validate()) {
			return [
				'error' => true,
				'result' => 'invalid'
			];
		}

		if(!isset($_POST['tax'])) {
			$_POST['tax-value'] = 0;
		}

		$result = DB::execute('INSERT INTO {table} ('.Validator::get_insert_field_string(self::FIELDS).') VALUES ('.Validator::get_insert_data_string(self::FIELDS, 'post').')', [
			'table' => self::TABLE_NAME,
		]);

		if(!$result) {
			return [
				'error' => true,
				'result' => 'insert_error'
			];
		}

		$id = DB::get_last_id();

		$result = DB::query('SELECT * FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(sizeof($result) < 1) {
			return [
				'error' => true,
				'result' => 'insert_error'
			];
		}

		return [
			'error' => false,
			'result' => $result[0]
		];
	}

	public static function update($id) {
		if(!self::validate()) {
			return [
				'error' => true,
				'result' => 'invalid'
			];
		}

		if(!isset($_POST['tax'])) {
			$_POST['tax-value'] = 0;
		}

		$id = intval($id);

		$result = DB::execute('UPDATE {table} SET '.Validator::get_update_data_string(self::FIELDS, 'post').' WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(!$result) {
			return [
				'error' => true,
				'result' => 'update_error'
			];
		}

		DB::execute('UPDATE {table} SET updated_at = NOW() WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(!$result) {
			return [
				'error' => true,
				'result' => 'update_error'
			];
		}

		$result = DB::query('SELECT * FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		if(sizeof($result) < 1) {
			return [
				'error' => true,
				'result' => 'update_error'
			];
		}

		return [
			'error' => false,
			'result' => $result[0]
		];
	}

	public static function delete($id) {
		$id = intval($id);

		return DB::execute('DELETE FROM {table} WHERE id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);
	}

	public static function detail($id) {
		$id = intval($id);

		$result = DB::query('SELECT *
			FROM {table}
			WHERE {table}.id = {id}', [
			'table' => self::TABLE_NAME,
			'id' => $id,
		]);

		return sizeof($result) == 0 ? false : $result[0];
	}

	public static function lists($start=0, $limit=PERPAGE, $order_by='id', $order='ASC') {
		$filter_name = '1';
		$filter_phone = '1';

		if(isset($_GET['phone'])) {
			$get_phone = trim($_GET['phone']);
			if($get_phone != '') {
				$filter_phone = '(phone LIKE "%'.$get_phone.'%" OR mobile LIKE "%'.$get_phone.'%")';
			}
		}

		if(isset($_GET['name'])) {
			$get_name = trim($_GET['name']);
			if($get_name != '') {
				$filter_name = 'name LIKE "%'.$get_name.'%"';
			}
		}

		return DB::query('SELECT * FROM {table} WHERE '.$filter_name.' AND '.$filter_phone.' ORDER BY {order_by} {order}', [
			'table' => self::TABLE_NAME,
			'start' => $start,
			'limit' => $limit,
			'order_by' => $order_by,
			'order' => $order,
		]);
	}

	public static function search($start=0, $limit=PERPAGE, $order_by='id', $order='ASC') {
		$filter_name = '0';
		$filter_nickname = '0';

		if(isset($_GET['search'])) {
			$get_search = trim($_GET['search']);
			if($get_search != '') {
				$filter_name = 'name LIKE "%'.$get_search.'%"';
				$filter_nickname = 'nickname LIKE "%'.$get_search.'%"';
			}
		}

		return DB::query('SELECT * FROM {table} WHERE '.$filter_name.' OR '.$filter_nickname.' ORDER BY {order_by} {order}', [
			'table' => self::TABLE_NAME,
			'start' => $start,
			'limit' => $limit,
			'order_by' => $order_by,
			'order' => $order,
		]);
	}

	public static function get() {
		if(isset($_GET['barcode'])) {
			$get_search = trim($_GET['barcode']);
			if($get_search != '') {
				$filter_barcode = 'barcode LIKE "%'.$get_search.'%"';
			}
		}

		$result =  DB::query('SELECT * FROM {table} WHERE '.$filter_barcode.' LIMIT 1', [
			'table' => self::TABLE_NAME,
		]);

		return sizeof($result) == 0 ? (object)[] : $result[0];
	}

	public static function validate() {
		return Validator::validate(self::FIELDS, 'post');
	}
}
?>
