<?php
	require 'include/lib.php';

	if(!isset($_GET['id']) || !intval($_GET['id'])) {
		HTML::script('alert("ไม่พบข้อมูล");window.close();');
	}

	$id = intval($_GET['id']);

	$data = Bill::detail($id);
	$customer = Customer::detail($data['customer_id']);

	if($data['invoiced']) {
		$invoice_sequence = Invoice::detail(intval($data['invoiced']));
		
	}
	else {
		$sequence = DB::query('SELECT (IFNULL(COUNT(1),0) + 1) AS sequence FROM invoice WHERE customer_id = {customer_id}', [
			'customer_id' => intval($data['customer_id']),
		]);
		$invoice_sequence = $sequence[0];
	}

	$title = 'Bill-'.str_replace('.', '', $customer['name']).'-'.str_replace('.', '', $customer['nickname']).'-'.intval($invoice_sequence['sequence']).'-'.intval($data['sequence']);
?>
<!DOCTYPE html>
<html>
<?php include 'head-print.html'; ?>
<body>
	<table width="100%">
		<tr>
			<th colspan="2">
				ใบส่งสินค้า/ใบเสร็จรับเงิน/ใบกำกับภาษี
			</th>
		</tr>
		<tr>
			<td>
				<?=$data['salesman_title'].$data['salesman_firstname'].' '.$data['salesman_lastname'];?>
			</td>
			<td class="right">
				<?php
					
					echo 'เล่มที่ '.$invoice_sequence['sequence'];
				?>
			</td>
		</tr>
		<tr>
			<td>
				<?=$data['salesman_address'];?>
			</td>
			<td class="right">
				บิลที่ <?=intval($data['sequence']);?>
			</td>
		</tr>
		<tr>
			<td>
				โทรศัพท์ : <?=($data['salesman_phone'] ? $data['salesman_phone'] : '-');?>&emsp;
				มือถือ : <?=($data['salesman_mobile'] ? $data['salesman_mobile'] : '-');?>&emsp;
			</td>
			<td class="right">
				<?=ThaiDate::toThaiDate($data['created_at'], 'd M Y');?>
			</td>
		</tr>
		<tr>
			<td>	
				เลขประจำตัวผู้เสียภาษี : <?=($data['salesman_fax'] ? $data['salesman_fax'] : '-');?>
			</td>
		</tr>
	</table>
	<br/>
	<table width="100%">
		<tr>
			<td class="bdt bdl bdr">
				ชื่อลูกค้า : <?=$customer['name'];?>
			</td>
		</tr>
		<tr>
			<td class="bdl bdr bdb">
				ที่อยู่ลูกค้า : <?=$customer['address'];?>
			</td>
		</tr>
	</table>
	<table width="100%">
		<tr>
			<td width="10%" class="center bdl bdr bdb">ลำดับ</td>
			<td width="45%" class="center bdr bdb">รายการ</td>
			<td width="15%" class="center bdr bdb">จำนวน</td>
			<td width="15%" class="center bdr bdb">ราคา</td>
			<td width="15%" class="center bdr bdb">รวม</td>
		</tr>
		<?php
			$bill_details = DB::query('SELECT * FROM bill_detail WHERE bill_id = {bill_id} ORDER BY sequence', [
				'bill_id' => intval($data['id'])
			]);

			$cnt = 0;
			$quantity = 0;
			$total = 0;
			$grand_total = 0;

			if(sizeof($bill_details) == 0) {
				echo '<tr>';
					echo '<td class="center bdl bdr bdb" colspan="4">ไม่พบข้อมูลการขายในระบบ</td>';
				echo '</tr>';
			}
			else {
				foreach ($bill_details as $key => $bill_detail) {
					$quantity += intval($bill_detail['product_quantity']);
					$total += intval($bill_detail['product_quantity'])*floatval($bill_detail['product_price']);
					echo '<tr>';
						echo '<td class="center bdl bdr bdb">'.(++$cnt).'</td>';
						echo '<td class="bdr bdb">'.$bill_detail['product_name'].'</td>';
						echo '<td class="right bdr bdb">'.number_format($bill_detail['product_quantity']).'</td>';
						echo '<td class="right bdr bdb">'.number_format($bill_detail['product_price'], 2).'</td>';
						echo '<td class="right bdr bdb">'.number_format($bill_detail['product_price']*$bill_detail['product_quantity'], 2).'</td>';

					echo '</tr>';
				}
			}

			$grand_total = $total;

			$discount = ($data['discount_type'] == 'baht' ? floatval($data['discount']) : $total * (floatval($data['discount'])/100.0));

			$total = ($total * 100 / (100+(floatval($data['tax_value']))));

			$tax_show = $grand_total - $total;

			$margin = 23;
			if($cnt < $margin) {
				$rows = $margin-$cnt;
				for($i = 0; $i < $rows; ++$i) {
					echo '<tr class="holder">';
						echo '<td class="bdl bdr">&nbsp;</td>';
						echo '<td class="bdr"></td>';
						echo '<td class="bdr"></td>';
						echo '<td class="bdr"></td>';
						echo '<td class="bdr"></td>';
					echo '</tr>';
				}
			}

		?>
		<tr>
			<td rowspan="4" colspan="2" class="vat bdt bdl bdr bdb">
				เปลี่ยน : <?=($data['remark'] ? $data['remark'] : '-');?>
			</td>
			<td class="center bdt bdr bdb">
				รวม
			</td>
			<td class="right bdt bdr bdb">
				<?=number_format($quantity);?>
			</td>
			<td class="right bdt bdr bdb">
				<?=number_format($total, 2);?>
			</td>
		</tr>
		<tr>
			<td class="center bdt bdr bdb">
				ส่วนลด
			</td>
			<td class="right bdt bdr bdb">
				<?=(floatval($data['discount']) == intval($data['discount']) ? number_format($data['discount'], 2) : number_format($data['discount'], 2)).($data['discount_type'] == 'baht' ? '' : ' %');?>
			</td>
			<td class="right bdt bdr bdb">
				<?=number_format($discount, 2);?>
			</td>
		</tr>
		<tr>
			<td class="center bdt bdr bdb">
				ภาษี
			</td>
			<td class="right bdt bdr bdb">
				<?=($data['tax_value'] > 0 ? (floatval($data['tax_value']) == intval($data['tax_value']) ? number_format($data['tax_value']) : number_format($data['tax_value'], 2)).' %' : '-');?>
			</td>
			<td class="right bdt bdr bdb">
				<?=number_format($tax_show, 2);?>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="center bdr">
				สุทธิ
			</td>
			<td class="right bdr">
				<?=number_format($grand_total - $discount, 2);?>
			</td>
		</tr>
		<tr>
			<td colspan="5" class="center bdl bdr bdb">
				จำนวนเงินเป็นตัวอักษร <?=BahtText::toBahtText($grand_total - $discount);?>
			</td>
		</tr>
	</table>
	<table width="100%">
		<tr>
			<td class="bdl bdr">
				<br/>
			</td>
			<td class="bdr">
				<br/>
			</td>
		</tr>
		<tr>
			<td class="center bdl bdr" width="50%">
				ลงชื่อ .................................................. ผู้รับสินค้า
			</td>
			<td class="center bdr" width="50%">
				ลงชื่อ .................................................. ผู้ส่งสินค้า
			</td>
		</tr>
		<tr>
			<td class="center bdl bdr">(..................................................)</td>
			<td class="center bdr">(..................................................)</td>
		</tr>
		<tr>
			<td class="center bdl bdr">วันที่ ........../........../..........</td>
			<td class="center bdr">วันที่ ........../........../..........</td>
		</tr>
		<tr>
			<td class="bdl bdr bdb">
				<br/>
			</td>
			<td class="bdr bdb">
				<br/>
			</td>
		</tr>
	</table>
	<script type="text/javascript">
		$().ready(function(){
			window.print();
			setTimeout(function(){
				window.close();
			}, 1);
		});
	</script>
</body>
</html>
